options(width = 120)

#*******************************************************************************#
#* Program: 2_harmonzd.tus_cps.1992.through.2019.add.replicate.weights.r        #
#* Date: August 2024                                                            #
#*                                                                              #
#* Purpose: R program to add the replicate weights to the 1992-2019             #
#*          harmonized data file.                                               #
#*                                                                              #
#*   Notes: The program uses the packages readr and plyr                        #
#*          The working directory location need to be modified                  #
#*          to match location of the data files.                                #
#*                                                                              #
#*          The R dataset of the harmonized 1992-2019 data needs to be          #
#*          created prior to running this code.  The dataset should be created  #
#*          using code that was included with the harmonized data file.         #
#*                                                                              #
#* Modifications: As of 8/2024, this program replaces                           #
#*          "1_harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta"    # 
#*          "2_harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta"    #
#*          "3_harmonzd_tus_cps_1992_through_2019_replicate_wgts_06_19_beta"    #
#*          "4_combine_reps_beta" and "6_combine_main_reps_beta" which were     #
#*          previously available on the TUS-CPS Website. The updated set of     #
#*          programs adds variable formats.                                     #
#*******************************************************************************#

##################################################################################
# Load libraries
#
library(readr)
library(plyr)

##################################################################################
# Set working directories
##################################################################################

setwd("//westat.com/DFS/NCIDCCPS/DCCPS - Global/Scientific Projects/TUS-CPS/Statistician/ifc/R work/prg/4. TUS-CPS 1992-2019 Harmonized Dataset")
getwd()

##################################################################################
# Set location of 92-93 replicate weight file
##################################################################################

Rep9293_data <- "./data/harmonzd.tus_cps.1992.through.2019.replicate.wgts.92_93.dat"


##################################################################################
## Create data dictionary with variable names, widths, type and labels
##################################################################################

data_diccionary <-
'SurYear    1   4    n     "Survey year"
SurMonth    5   6    n     "Survey month" 
RecordID    7   28   c     "Record ID (Unique within survey month)"
SmplWgt     29  39   d     "Self Response Weight"
RepWt001    40  50   d     "Self Response Weight # 1"
RepWt002    51  61   d     "Self Response Weight # 2"
RepWt003    62  72   d     "Self Response Weight # 3"
RepWt004    73  83   d     "Self Response Weight # 4"
RepWt005    84  94   d     "Self Response Weight # 5"
RepWt006    95  105  d     "Self Response Weight # 6"
RepWt007    106 116  d     "Self Response Weight # 7"
RepWt008    117 127  d     "Self Response Weight # 8"
RepWt009    128 138  d     "Self Response Weight # 9"
RepWt010    139 149  d     "Self Response Weight # 10"
RepWt011    150 160  d     "Self Response Weight # 11"
RepWt012    161 171  d     "Self Response Weight # 12"
RepWt013    172 182  d     "Self Response Weight # 13"
RepWt014    183 193  d     "Self Response Weight # 14"
RepWt015    194 204  d     "Self Response Weight # 15"
RepWt016    205 215  d     "Self Response Weight # 16"
RepWt017    216 226  d     "Self Response Weight # 17"
RepWt018    227 237  d     "Self Response Weight # 18"
RepWt019    238 248  d     "Self Response Weight # 19"
RepWt020    249 259  d     "Self Response Weight # 20"
RepWt021    260 270  d     "Self Response Weight # 21"
RepWt022    271 281  d     "Self Response Weight # 22"
RepWt023    282 292  d     "Self Response Weight # 23"
RepWt024    293 303  d     "Self Response Weight # 24"
RepWt025    304 314  d     "Self Response Weight # 25"
RepWt026    315 325  d     "Self Response Weight # 26"
RepWt027    326 336  d     "Self Response Weight # 27"
RepWt028    337 347  d     "Self Response Weight # 28"
RepWt029    348 358  d     "Self Response Weight # 29"
RepWt030    359 369  d     "Self Response Weight # 30"
RepWt031    370 380  d     "Self Response Weight # 31"
RepWt032    381 391  d     "Self Response Weight # 32"
RepWt033    392 402  d     "Self Response Weight # 33"
RepWt034    403 413  d     "Self Response Weight # 34"
RepWt035    414 424  d     "Self Response Weight # 35"
RepWt036    425 435  d     "Self Response Weight # 36"
RepWt037    436 446  d     "Self Response Weight # 37"
RepWt038    447 457  d     "Self Response Weight # 38"
RepWt039    458 468  d     "Self Response Weight # 39"
RepWt040    469 479  d     "Self Response Weight # 40"
RepWt041    480 490  d     "Self Response Weight # 41"
RepWt042    491 501  d     "Self Response Weight # 42"
RepWt043    502 512  d     "Self Response Weight # 43"
RepWt044    513 523  d     "Self Response Weight # 44"
RepWt045    524 534  d     "Self Response Weight # 45"
RepWt046    535 545  d     "Self Response Weight # 46"
RepWt047    546 556  d     "Self Response Weight # 47"
RepWt048    557 567  d     "Self Response Weight # 48"'

##################################################################################
# Create data dictionary
##################################################################################

tmp_file <- tempfile()
writeLines(data_diccionary, tmp_file)
data_diccionary_table <- read.table(tmp_file,sep="", col.names = c("variable", "initial_position","final_position", "type", "label"))

data_diccionary_tabletype <- as.character(data_diccionary_table$type)

### Create list for varaible name and type 
names(data_diccionary_tabletype) <-  data_diccionary_table$variable
data_diccionary_tabletype <- as.list(data_diccionary_tabletype)

##################################################################################
## Read the 1992-1993 replicate weights 
##

Rep9293 <- as.data.frame(read_fwf(Rep9293_data, 
                 col_positions = fwf_positions( data_diccionary_table$initial_position, 
                                 data_diccionary_table$final_position,
                                  col_names= data_diccionary_table$variable),
                 col_types = data_diccionary_tabletype  )) 

##################################################################################
## Attach labels
##################################################################################
for (i in 1:length(data_diccionary_table$variable))
{
  attr(Rep9293[,i],"label") <- data_diccionary_table$label[i]
}

##################################################################################
##################################################################################
# Read 1995-2003 replicate weight file
##################################################################################

Rep9503_data <- "./data/harmonzd.tus_cps.1992.through.2019.replicate.wgts.95_03.dat"


##################################################################################
## Create data dictionary with variable names, widths, type and labels
##################################################################################

data_diccionary <-
'SurYear    1   4    n     "Survey year"
SurMonth    5   6    n     "Survey month" 
RecordID    7   28   c     "Record ID (Unique within survey month)"
SmplWgt     29  39   d     "Self Response Weight"
RepWt001    40  50   d     "Self Response Weight # 1"
RepWt002    51  61   d     "Self Response Weight # 2"
RepWt003    62  72   d     "Self Response Weight # 3"
RepWt004    73  83   d     "Self Response Weight # 4"
RepWt005    84  94   d     "Self Response Weight # 5"
RepWt006    95  105  d     "Self Response Weight # 6"
RepWt007    106 116  d     "Self Response Weight # 7"
RepWt008    117 127  d     "Self Response Weight # 8"
RepWt009    128 138  d     "Self Response Weight # 9"
RepWt010    139 149  d     "Self Response Weight # 10"
RepWt011    150 160  d     "Self Response Weight # 11"
RepWt012    161 171  d     "Self Response Weight # 12"
RepWt013    172 182  d     "Self Response Weight # 13"
RepWt014    183 193  d     "Self Response Weight # 14"
RepWt015    194 204  d     "Self Response Weight # 15"
RepWt016    205 215  d     "Self Response Weight # 16"
RepWt017    216 226  d     "Self Response Weight # 17"
RepWt018    227 237  d     "Self Response Weight # 18"
RepWt019    238 248  d     "Self Response Weight # 19"
RepWt020    249 259  d     "Self Response Weight # 20"
RepWt021    260 270  d     "Self Response Weight # 21"
RepWt022    271 281  d     "Self Response Weight # 22"
RepWt023    282 292  d     "Self Response Weight # 23"
RepWt024    293 303  d     "Self Response Weight # 24"
RepWt025    304 314  d     "Self Response Weight # 25"
RepWt026    315 325  d     "Self Response Weight # 26"
RepWt027    326 336  d     "Self Response Weight # 27"
RepWt028    337 347  d     "Self Response Weight # 28"
RepWt029    348 358  d     "Self Response Weight # 29"
RepWt030    359 369  d     "Self Response Weight # 30"
RepWt031    370 380  d     "Self Response Weight # 31"
RepWt032    381 391  d     "Self Response Weight # 32"
RepWt033    392 402  d     "Self Response Weight # 33"
RepWt034    403 413  d     "Self Response Weight # 34"
RepWt035    414 424  d     "Self Response Weight # 35"
RepWt036    425 435  d     "Self Response Weight # 36"
RepWt037    436 446  d     "Self Response Weight # 37"
RepWt038    447 457  d     "Self Response Weight # 38"
RepWt039    458 468  d     "Self Response Weight # 39"
RepWt040    469 479  d     "Self Response Weight # 40"
RepWt041    480 490  d     "Self Response Weight # 41"
RepWt042    491 501  d     "Self Response Weight # 42"
RepWt043    502 512  d     "Self Response Weight # 43"
RepWt044    513 523  d     "Self Response Weight # 44"
RepWt045    524 534  d     "Self Response Weight # 45"
RepWt046    535 545  d     "Self Response Weight # 46"
RepWt047    546 556  d     "Self Response Weight # 47"
RepWt048    557 567  d     "Self Response Weight # 48"
RepWt049    568 578  d     "Self Response Weight # 49"
RepWt050    579 589  d     "Self Response Weight # 50"
RepWt051    590 600  d     "Self Response Weight # 51"
RepWt052    601 611  d     "Self Response Weight # 52"
RepWt053    612 622  d     "Self Response Weight # 53"
RepWt054    623 633  d     "Self Response Weight # 54"
RepWt055    634 644  d     "Self Response Weight # 55"
RepWt056    645 655  d     "Self Response Weight # 56"
RepWt057    656 666  d     "Self Response Weight # 57"
RepWt058    667 677  d     "Self Response Weight # 58"
RepWt059    678 688  d     "Self Response Weight # 59"
RepWt060    689 699  d     "Self Response Weight # 60"
RepWt061    700 710  d     "Self Response Weight # 61"
RepWt062    711 721  d     "Self Response Weight # 62"
RepWt063    722 732  d     "Self Response Weight # 63"
RepWt064    733 743  d     "Self Response Weight # 64"
RepWt065    744 754  d     "Self Response Weight # 65"
RepWt066    755 765  d     "Self Response Weight # 66"
RepWt067    766 776  d     "Self Response Weight # 67"
RepWt068    777 787  d     "Self Response Weight # 68"
RepWt069    788 798  d     "Self Response Weight # 69"
RepWt070    799 809  d     "Self Response Weight # 70"
RepWt071    810 820  d     "Self Response Weight # 71"
RepWt072    821 831  d     "Self Response Weight # 72"
RepWt073    832 842  d     "Self Response Weight # 73"
RepWt074    843 853  d     "Self Response Weight # 74"
RepWt075    854 864  d     "Self Response Weight # 75"
RepWt076    865 875  d     "Self Response Weight # 76"
RepWt077    876 886  d     "Self Response Weight # 77"
RepWt078    887 897  d     "Self Response Weight # 78"
RepWt079    898 908  d     "Self Response Weight # 79"
RepWt080    909 919  d     "Self Response Weight # 80"'

##################################################################################
# Create data dictionary
##################################################################################

tmp_file <- tempfile()
writeLines(data_diccionary, tmp_file)
data_diccionary_table <- read.table(tmp_file,sep="", col.names = c("variable", "initial_position","final_position", "type", "label"))

data_diccionary_tabletype <- as.character(data_diccionary_table$type)

### Create list for varaible name and type 
names(data_diccionary_tabletype) <-  data_diccionary_table$variable
data_diccionary_tabletype <- as.list(data_diccionary_tabletype)

##################################################################################
## Read  the 1995-2003 replicate weights 
##

Rep9503 <- as.data.frame(read_fwf(Rep9503_data, 
                 col_positions = fwf_positions( data_diccionary_table$initial_position, 
                                 data_diccionary_table$final_position,
                                  col_names= data_diccionary_table$variable),
                 col_types = data_diccionary_tabletype  )) 

##################################################################################
## Attach labels
##################################################################################
for (i in 1:length(data_diccionary_table$variable))
{
  attr(Rep9503[,i],"label") <- data_diccionary_table$label[i]
}

##################################################################################
##################################################################################
##################################################################################
# Read 2006-2019 replicate weight file
##################################################################################

Rep0619_data <- "./data/harmonzd.tus_cps.1992.through.2019.replicate.wgts.06_19.dat"


##################################################################################
## Create data dictionary with variable names, widths, type and labels
##################################################################################

data_diccionary <-
'SurYear    1      4      n     "Survey year"
SurMonth    5      6      n     "Survey month" 
RecordID    7      28     c     "Record ID (Unique within survey month)"
SmplWgt     29     39     d     "Self Response Weight"
RepWt001    40     50     d     "Self Response Weight # 1"
RepWt002    51     61     d     "Self Response Weight # 2"
RepWt003    62     72     d     "Self Response Weight # 3"
RepWt004    73     83     d     "Self Response Weight # 4"
RepWt005    84     94     d     "Self Response Weight # 5"
RepWt006    95     105    d     "Self Response Weight # 6"
RepWt007    106    116    d     "Self Response Weight # 7"
RepWt008    117    127    d     "Self Response Weight # 8"
RepWt009    128    138    d     "Self Response Weight # 9"
RepWt010    139    149    d     "Self Response Weight # 10"
RepWt011    150    160    d     "Self Response Weight # 11"
RepWt012    161    171    d     "Self Response Weight # 12"
RepWt013    172    182    d     "Self Response Weight # 13"
RepWt014    183    193    d     "Self Response Weight # 14"
RepWt015    194    204    d     "Self Response Weight # 15"
RepWt016    205    215    d     "Self Response Weight # 16"
RepWt017    216    226    d     "Self Response Weight # 17"
RepWt018    227    237    d     "Self Response Weight # 18"
RepWt019    238    248    d     "Self Response Weight # 19"
RepWt020    249    259    d     "Self Response Weight # 20"
RepWt021    260    270    d     "Self Response Weight # 21"
RepWt022    271    281    d     "Self Response Weight # 22"
RepWt023    282    292    d     "Self Response Weight # 23"
RepWt024    293    303    d     "Self Response Weight # 24"
RepWt025    304    314    d     "Self Response Weight # 25"
RepWt026    315    325    d     "Self Response Weight # 26"
RepWt027    326    336    d     "Self Response Weight # 27"
RepWt028    337    347    d     "Self Response Weight # 28"
RepWt029    348    358    d     "Self Response Weight # 29"
RepWt030    359    369    d     "Self Response Weight # 30"
RepWt031    370    380    d     "Self Response Weight # 31"
RepWt032    381    391    d     "Self Response Weight # 32"
RepWt033    392    402    d     "Self Response Weight # 33"
RepWt034    403    413    d     "Self Response Weight # 34"
RepWt035    414    424    d     "Self Response Weight # 35"
RepWt036    425    435    d     "Self Response Weight # 36"
RepWt037    436    446    d     "Self Response Weight # 37"
RepWt038    447    457    d     "Self Response Weight # 38"
RepWt039    458    468    d     "Self Response Weight # 39"
RepWt040    469    479    d     "Self Response Weight # 40"
RepWt041    480    490    d     "Self Response Weight # 41"
RepWt042    491    501    d     "Self Response Weight # 42"
RepWt043    502    512    d     "Self Response Weight # 43"
RepWt044    513    523    d     "Self Response Weight # 44"
RepWt045    524    534    d     "Self Response Weight # 45"
RepWt046    535    545    d     "Self Response Weight # 46"
RepWt047    546    556    d     "Self Response Weight # 47"
RepWt048    557    567    d     "Self Response Weight # 48"
RepWt049    568    578    d     "Self Response Weight # 49"
RepWt050    579    589    d     "Self Response Weight # 50"
RepWt051    590    600    d     "Self Response Weight # 51"
RepWt052    601    611    d     "Self Response Weight # 52"
RepWt053    612    622    d     "Self Response Weight # 53"
RepWt054    623    633    d     "Self Response Weight # 54"
RepWt055    634    644    d     "Self Response Weight # 55"
RepWt056    645    655    d     "Self Response Weight # 56"
RepWt057    656    666    d     "Self Response Weight # 57"
RepWt058    667    677    d     "Self Response Weight # 58"
RepWt059    678    688    d     "Self Response Weight # 59"
RepWt060    689    699    d     "Self Response Weight # 60"
RepWt061    700    710    d     "Self Response Weight # 61"
RepWt062    711    721    d     "Self Response Weight # 62"
RepWt063    722    732    d     "Self Response Weight # 63"
RepWt064    733    743    d     "Self Response Weight # 64"
RepWt065    744    754    d     "Self Response Weight # 65"
RepWt066    755    765    d     "Self Response Weight # 66"
RepWt067    766    776    d     "Self Response Weight # 67"
RepWt068    777    787    d     "Self Response Weight # 68"
RepWt069    788    798    d     "Self Response Weight # 69"
RepWt070    799    809    d     "Self Response Weight # 70"
RepWt071    810    820    d     "Self Response Weight # 71"
RepWt072    821    831    d     "Self Response Weight # 72"
RepWt073    832    842    d     "Self Response Weight # 73"
RepWt074    843    853    d     "Self Response Weight # 74"
RepWt075    854    864    d     "Self Response Weight # 75"
RepWt076    865    875    d     "Self Response Weight # 76"
RepWt077    876    886    d     "Self Response Weight # 77"
RepWt078    887    897    d     "Self Response Weight # 78"
RepWt079    898    908    d     "Self Response Weight # 79"
RepWt080    909    919    d     "Self Response Weight # 80"
RepWt081    920    930    d     "Self Response Weight # 81"
RepWt082    931    941    d     "Self Response Weight # 82"
RepWt083    942    952    d     "Self Response Weight # 83"
RepWt084    953    963    d     "Self Response Weight # 84"
RepWt085    964    974    d     "Self Response Weight # 85"
RepWt086    975    985    d     "Self Response Weight # 86"
RepWt087    986    996    d     "Self Response Weight # 87"
RepWt088    997    1007   d     "Self Response Weight # 88"
RepWt089    1008   1018   d     "Self Response Weight # 89"
RepWt090    1019   1029   d     "Self Response Weight # 90"
RepWt091    1030   1040   d     "Self Response Weight # 91"
RepWt092    1041   1051   d     "Self Response Weight # 92"
RepWt093    1052   1062   d     "Self Response Weight # 93"
RepWt094    1063   1073   d     "Self Response Weight # 94"
RepWt095    1074   1084   d     "Self Response Weight # 95"
RepWt096    1085   1095   d     "Self Response Weight # 96"
RepWt097    1096   1106   d     "Self Response Weight # 97"
RepWt098    1107   1117   d     "Self Response Weight # 98"
RepWt099    1118   1128   d     "Self Response Weight # 99"
RepWt100    1129   1139   d     "Self Response Weight # 100"
RepWt101    1140   1150   d     "Self Response Weight # 101"
RepWt102    1151   1161   d     "Self Response Weight # 102"
RepWt103    1162   1172   d     "Self Response Weight # 103"
RepWt104    1173   1183   d     "Self Response Weight # 104"
RepWt105    1184   1194   d     "Self Response Weight # 105"
RepWt106    1195   1205   d     "Self Response Weight # 106"
RepWt107    1206   1216   d     "Self Response Weight # 107"
RepWt108    1217   1227   d     "Self Response Weight # 108"
RepWt109    1228   1238   d     "Self Response Weight # 109"
RepWt110    1239   1249   d     "Self Response Weight # 110"
RepWt111    1250   1260   d     "Self Response Weight # 111"
RepWt112    1261   1271   d     "Self Response Weight # 112"
RepWt113    1272   1282   d     "Self Response Weight # 113"
RepWt114    1283   1293   d     "Self Response Weight # 114"
RepWt115    1294   1304   d     "Self Response Weight # 115"
RepWt116    1305   1315   d     "Self Response Weight # 116"
RepWt117    1316   1326   d     "Self Response Weight # 117"
RepWt118    1327   1337   d     "Self Response Weight # 118"
RepWt119    1338   1348   d     "Self Response Weight # 119"
RepWt120    1349   1359   d     "Self Response Weight # 120"
RepWt121    1360   1370   d     "Self Response Weight # 121"
RepWt122    1371   1381   d     "Self Response Weight # 122"
RepWt123    1382   1392   d     "Self Response Weight # 123"
RepWt124    1393   1403   d     "Self Response Weight # 124"
RepWt125    1404   1414   d     "Self Response Weight # 125"
RepWt126    1415   1425   d     "Self Response Weight # 126"
RepWt127    1426   1436   d     "Self Response Weight # 127"
RepWt128    1437   1447   d     "Self Response Weight # 128"
RepWt129    1448   1458   d     "Self Response Weight # 129"
RepWt130    1459   1469   d     "Self Response Weight # 130"
RepWt131    1470   1480   d     "Self Response Weight # 131"
RepWt132    1481   1491   d     "Self Response Weight # 132"
RepWt133    1492   1502   d     "Self Response Weight # 133"
RepWt134    1503   1513   d     "Self Response Weight # 134"
RepWt135    1514   1524   d     "Self Response Weight # 135"
RepWt136    1525   1535   d     "Self Response Weight # 136"
RepWt137    1536   1546   d     "Self Response Weight # 137"
RepWt138    1547   1557   d     "Self Response Weight # 138"
RepWt139    1558   1568   d     "Self Response Weight # 139"
RepWt140    1569   1579   d     "Self Response Weight # 140"
RepWt141    1580   1590   d     "Self Response Weight # 141"
RepWt142    1591   1601   d     "Self Response Weight # 142"
RepWt143    1602   1612   d     "Self Response Weight # 143"
RepWt144    1613   1623   d     "Self Response Weight # 144"
RepWt145    1624   1634   d     "Self Response Weight # 145"
RepWt146    1635   1645   d     "Self Response Weight # 146"
RepWt147    1646   1656   d     "Self Response Weight # 147"
RepWt148    1657   1667   d     "Self Response Weight # 148"
RepWt149    1668   1678   d     "Self Response Weight # 149"
RepWt150    1679   1689   d     "Self Response Weight # 150"
RepWt151    1690   1700   d     "Self Response Weight # 151"
RepWt152    1701   1711   d     "Self Response Weight # 152"
RepWt153    1712   1722   d     "Self Response Weight # 153"
RepWt154    1723   1733   d     "Self Response Weight # 154"
RepWt155    1734   1744   d     "Self Response Weight # 155"
RepWt156    1745   1755   d     "Self Response Weight # 156"
RepWt157    1756   1766   d     "Self Response Weight # 157"
RepWt158    1767   1777   d     "Self Response Weight # 158"
RepWt159    1778   1788   d     "Self Response Weight # 159"
RepWt160    1789   1799   d     "Self Response Weight # 160"'

##################################################################################
# Create data dictionary
##################################################################################

tmp_file <- tempfile()
writeLines(data_diccionary, tmp_file)
data_diccionary_table <- read.table(tmp_file,sep="", col.names = c("variable", "initial_position","final_position", "type", "label"))

data_diccionary_tabletype <- as.character(data_diccionary_table$type)

### Create list for varaible name and type 
names(data_diccionary_tabletype) <-  data_diccionary_table$variable
data_diccionary_tabletype <- as.list(data_diccionary_tabletype)

##################################################################################
## Read the 2006-2019 replicate weights 
##

Rep0619 <- as.data.frame(read_fwf(Rep0619_data, 
                 col_positions = fwf_positions( data_diccionary_table$initial_position, 
                                 data_diccionary_table$final_position,
                                  col_names= data_diccionary_table$variable),
                 col_types = data_diccionary_tabletype  )) 

##################################################################################
## Attach labels
##################################################################################
for (i in 1:length(data_diccionary_table$variable))
{
  attr(Rep0619[,i],"label") <- data_diccionary_table$label[i]
}

##################################################################################
## Append files with replicates 
##################################################################################

Reps <- rbind.fill(Rep9293, Rep9503, Rep0619 )
Reps$Reps_File <- 1

##################################################################################
## Attach levels of varaibles 
##################################################################################
# Variable:SurMonth Format: SURMONTF levels:8
Reps$SurMonth <- as.factor(Reps$SurMonth)
all_values <- c(1 ,2  , 5  , 6  , 7  , 8  , 9  , 11 ) 
all_levels <- c("1: January" ,
                "2: February"  , 
                "5: May"  , 
                "6: June"  , 
                "7: July"  , 
                "8: August"  , 
                "9: September"  , 
                "11: November" ) 
var_levels <-  levels(Reps$SurMonth)
valid_levels <- intersect(var_levels, all_values)
valid_labels <- all_levels [match(valid_levels, all_values)]
valid_positions <- match(valid_levels, var_levels)
levels(Reps$SurMonth)[valid_positions] <- valid_labels
table(Reps$SurMonth, useNA="ifany")

##################################################################################
## Read the Harmonized data
##################################################################################

Harmon <- readRDS(file="./data/Harmon.RDS", refhook = NULL)
Harmon$Harm_File <- 1

Harmon <- Harmon[order(Harmon$SurYear, Harmon$SurMonth, Harmon$RecordID),]

##################################################################################
## Merge the Harmonized data and replicate weights
##################################################################################

Harmon2 <- merge(Harmon,Reps,by=c("SurYear","SurMonth", "RecordID"), all = TRUE)

##################################################################################
## Check merge
##################################################################################
table(Harmon2$Reps_File, Harmon2$Harm_File)

##################################################################################
## Saving data as a RDS File
##################################################################################

str(Harmon2, list.len=ncol(Harmon2))

saveRDS(Harmon2, file = "./data/Harmon2.RDS")

